/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager;

import com.algoritmusistemos.packager.Constants;
import com.algoritmusistemos.packager.model.SecurePackagerResult;
import com.algoritmusistemos.packager.model.SecureUnpackerResult;
import com.algoritmusistemos.packager.service.SecurePackagerService;
import com.algoritmusistemos.packager.service.impl.SecurePackagerServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;

public class Main {
    private static final String UNPACK = "unpack";
    private static final String PACK = "pack";
    private SecurePackagerService pkger = new SecurePackagerServiceImpl();

    public Main() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SENDER_KEYSTORE", Constants.KEYSTORE);
        params.put("SENDER_KEYSTORE_PASS", Constants.KEYSTORE_PASS);
        params.put("SENDER_KEYSTORE_KEY", Constants.KEYSTORE_KEY);
        params.put("RECEIVER_KEYSTORE", Constants.KEYSTORE_USA);
        params.put("RECEIVER_KEYSTORE_PASS", Constants.KEYSTORE_USA_PASS);
        params.put("RECEIVER_KEYSTORE_KEY", Constants.KEYSTORE_USA_KEY);
        this.pkger.initialize(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        String mode = Main.getMode(args);
        System.out.println("Working Directory = " + System.getProperty("user.dir"));
        System.out.println("JAVA = " + System.getProperty("java.class.path"));
        Main m = new Main();
        if (UNPACK.equals(mode)) {
            String zip = Base64.getEncoder().encodeToString(Main.readFile("20170130T141128045Z_125774645.zip"));
            SecureUnpackerResult res = m.pkger.unpack(zip);
            byte[] bytes = Base64.getDecoder().decode(res.getPayload());
            System.out.println(new String(bytes));
        } else {
            long startTime = System.currentTimeMillis();
            String xml = Main.readFile(Constants.PAYLOAD, Charset.forName("UTF-8"));
            String base64String = Base64.getEncoder().encodeToString(xml.getBytes("UTF-8"));
            SecurePackagerResult res = m.pkger.pack(base64String, Constants.GIIN, Constants.USA_GIIN);
            byte[] data = Base64.getDecoder().decode(res.getPkg());
            long endTime = System.currentTimeMillis();
            System.out.println("Execution time " + (endTime - startTime));
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(new File(res.getSenderFileId()));
                fos.write(data);
            }
        }
    }

    public static byte[] readFile(String path) throws IOException {
        RandomAccessFile f = new RandomAccessFile(path, "r");
        byte[] data = new byte[(int)f.length()];
        f.read(data);
        return data;
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        return new String(Main.readFile(path), encoding);
    }

    private static String getMode(String[] args) {
        if (args.length > 1) {
            throw new IllegalArgumentException("Invalid number of arguments passed.");
        }
        if (args.length == 1) {
            if (UNPACK.equals(args[0]) || PACK.equals(args[0])) {
                return args[0];
            }
            throw new IllegalArgumentException("Illegal argument passed.");
        }
        return null;
    }
}

