/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.impl;

import com.algoritmusistemos.packager.model.SecurePackagerResult;
import com.algoritmusistemos.packager.model.SecureUnpackerResult;
import com.algoritmusistemos.packager.service.impl.SecureXmlSigner;
import com.algoritmusistemos.packager.service.util.EncryptionUtils;
import com.algoritmusistemos.packager.service.util.IOUtils;
import com.algoritmusistemos.packager.service.util.ZipUtils;
import com.algoritmusistemos.packager.service.util.exception.SecurePackagerErrors;
import com.algoritmusistemos.packager.service.util.exception.SecurePackagerException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.xml.stream.XMLStreamException;

public class SecurePackager {
    private final SecureXmlSigner signer = new SecureXmlSigner();
    private final SimpleDateFormat sdfFileName = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS'Z'");
    private final SimpleDateFormat sdfFileCreateTs = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public SecurePackager() {
        this.sdfFileName.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.sdfFileCreateTs.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public SecurePackagerResult signAndCreatePkg(String xml, PrivateKey senderPrivateKey, String senderGiin, String receiverGiin, X509Certificate receiverPublicCert) throws Exception {
        String decodedXml = new String(Base64.getDecoder().decode(xml), "UTF-8");
        String signedXml = this.signer.signXML(decodedXml, senderPrivateKey);
        return this.createPkg(signedXml, senderGiin, receiverGiin, receiverPublicCert);
    }

    public SecureUnpackerResult unpack(String base64zip, PrivateKey privateKey) throws SecurePackagerException {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(base64zip));
        ZipInputStream zis = null;
        InputStream payloadIS = null;
        byte[] receiverKey = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(bais);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().contains("Payload")) {
                    payloadIS = IOUtils.toInputStream(zis);
                    continue;
                }
                if (!entry.getName().contains("Key")) continue;
                receiverKey = IOUtils.toByteArray(zis);
            }
        }
        catch (IOException ex) {
            throw new SecurePackagerException(SecurePackagerErrors.NDP, ex.getMessage());
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (payloadIS == null) {
            throw new SecurePackagerException(SecurePackagerErrors.NDP, "Payload missing");
        }
        if (receiverKey == null) {
            throw new SecurePackagerException(SecurePackagerErrors.NDP, "Key missing");
        }
        SecretKey skey = null;
        try {
            skey = EncryptionUtils.decryptAESKey(receiverKey, privateKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SecurePackagerException(SecurePackagerErrors.NDC, "AES key", ex.getMessage());
        }
        ZipInputStream payloadZIS = null;
        try {
            Cipher aesCipher = EncryptionUtils.aes(2, skey);
            payloadZIS = new ZipInputStream(EncryptionUtils.applyCipher(payloadIS, aesCipher));
        }
        catch (Exception ex) {
            if (ex instanceof SecurePackagerException) {
                throw (SecurePackagerException)ex;
            }
            throw new SecurePackagerException(SecurePackagerErrors.NDC, "payload", ex.getMessage());
        }
        try {
            payloadZIS.getNextEntry();
        }
        catch (IOException ex) {
            throw new SecurePackagerException(SecurePackagerErrors.NDP, ex.getMessage());
        }
        SecureUnpackerResult result = new SecureUnpackerResult();
        try {
            result.setPayload(Base64.getEncoder().encodeToString(this.signer.removeSignature(payloadZIS)));
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurePackagerResult createPkg(String signedXml, String senderGiin, String receiverGiin, X509Certificate receiverPublicCert) throws Exception {
        String senderFileId = this.getIDESFileName(senderGiin);
        String xmlZipFileName = this.getFileName(senderGiin, "_Payload.zip");
        String payloadFileName = this.getFileName(senderGiin, "_Payload.xml");
        String xmlZipEncryptedFileName = this.getFileName(senderGiin, "_Payload");
        String encryptedAESKeyFileName = this.getFileName(receiverGiin, "_Key");
        SecretKey aesKey = EncryptionUtils.generateAESKey();
        InputStream signedXmlIS = IOUtils.toInputStream(signedXml);
        ByteArrayInputStream xmlZipIS = ZipUtils.createZipFile(Collections.singletonMap(payloadFileName, signedXmlIS), xmlZipFileName);
        Cipher aesCipher = EncryptionUtils.aes(1, aesKey);
        InputStream xmlEncryptedZipIS = EncryptionUtils.applyCipher(xmlZipIS, aesCipher);
        SecretKey aesKeyWithIV = EncryptionUtils.mergeAESKeyWithIV(aesKey, aesCipher.getIV());
        InputStream aesKeyIS = EncryptionUtils.encryptAESKey(aesKeyWithIV, receiverPublicCert.getPublicKey());
        HashMap<String, InputStream> entries = new HashMap<String, InputStream>();
        entries.put(xmlZipEncryptedFileName, xmlEncryptedZipIS);
        entries.put(encryptedAESKeyFileName, aesKeyIS);
        String encodedZip = null;
        try (ByteArrayInputStream zip = null;){
            zip = ZipUtils.createZipFile(entries, senderFileId);
            byte[] zipArray = new byte[zip.available()];
            zip.read(zipArray);
            encodedZip = Base64.getEncoder().encodeToString(zipArray);
        }
        SecurePackagerResult result = new SecurePackagerResult();
        Date date = new Date();
        result.setFileCreateTs(this.sdfFileCreateTs.format(date));
        result.setSenderFileId(senderFileId + ".zip");
        result.setPkg(encodedZip);
        return result;
    }

    private String getFileName(String senderGiin, String filename) {
        return senderGiin + filename;
    }

    private String getIDESFileName(String senderGiin) {
        Date date = new Date();
        return this.sdfFileName.format(date) + "_" + senderGiin;
    }
}

