/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.impl;

import com.algoritmusistemos.packager.model.SecurePackagerResult;
import com.algoritmusistemos.packager.model.SecureUnpackerResult;
import com.algoritmusistemos.packager.service.SecurePackagerService;
import com.algoritmusistemos.packager.service.impl.SecurePackager;
import com.algoritmusistemos.packager.service.util.KeyStoreUtils;
import com.algoritmusistemos.packager.service.util.exception.SecurePackagerException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;

public class SecurePackagerServiceImpl
implements SecurePackagerService {
    private SecurePackager pkger;
    private PrivateKey senderSigKey;
    private X509Certificate receiverCert;

    @Override
    public void initialize(Map<String, String> params) {
        try {
            this.pkger = new SecurePackager();
            this.senderSigKey = KeyStoreUtils.getPrivateKey("jks", params.get("SENDER_KEYSTORE"), params.get("SENDER_KEYSTORE_PASS"), params.get("SENDER_KEYSTORE_PASS"), params.get("SENDER_KEYSTORE_KEY"));
            this.receiverCert = KeyStoreUtils.getCert("jks", params.get("RECEIVER_KEYSTORE"), params.get("RECEIVER_KEYSTORE_PASS"), params.get("RECEIVER_KEYSTORE_KEY"));
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to initialize packager.", ex);
        }
    }

    @Override
    public void initialize(Map<String, String> params, X509Certificate cert) {
        try {
            this.pkger = new SecurePackager();
            this.senderSigKey = KeyStoreUtils.getPrivateKey("jks", params.get("SENDER_KEYSTORE"), params.get("SENDER_KEYSTORE_PASS"), params.get("SENDER_KEYSTORE_PASS"), params.get("SENDER_KEYSTORE_KEY"));
            this.receiverCert = cert;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to initialize packager.", ex);
        }
    }

    @Override
    public SecurePackagerResult pack(String xml, String senderGin, String receiverGin) {
        try {
            return this.pkger.signAndCreatePkg(xml, this.senderSigKey, senderGin, receiverGin, this.receiverCert);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to package data.", ex);
        }
    }

    @Override
    public SecureUnpackerResult unpack(String zipBase64) throws SecurePackagerException {
        return this.pkger.unpack(zipBase64, this.senderSigKey);
    }
}

