/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.impl;

import com.algoritmusistemos.packager.service.util.IOUtils;
import com.algoritmusistemos.packager.service.util.IgnoreErrorHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SecureXmlSigner {
    public static final String SIGNATURE_OBJECT_ID = "FATCA";
    public static final String SIGNATUER_ALGO = "SHA256withRSA";
    public static final String MESSAGE_DIGEST_ALGO = "SHA-256";
    public static final String SIGNATURE_DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static String DOCUMENT_BUILDER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    public static String TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static final int bufSize = 65536;
    private static final String digprefix = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"FATCA\">";
    private static final String digsuffix = "</Object>";
    private XMLSignatureFactory xmlSigFactory = null;
    private TransformerFactory transformerFactory = null;
    private Canonicalizer canonicalizer = null;
    private DocumentBuilder docBuilder = null;
    private XMLInputFactory xmlInputFactory;
    private XMLOutputFactory xmlOutputFactory;
    protected String digestValue = null;
    protected String signatureValue = null;
    protected MessageDigest messageDigest = null;

    public SecureXmlSigner() {
        try {
            Init.init();
            this.xmlInputFactory = XMLInputFactory.newFactory();
            this.xmlOutputFactory = XMLOutputFactory.newFactory();
            this.canonicalizer = Canonicalizer.getInstance(CANONICALIZATION_METHOD);
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance(DOCUMENT_BUILDER_FACTORY, null);
            dfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(true);
            this.docBuilder = dfactory.newDocumentBuilder();
            this.docBuilder.setErrorHandler(new IgnoreErrorHandler());
            this.transformerFactory = TransformerFactory.newInstance(TRANSFORMER_FACTORY, null);
            this.xmlSigFactory = XMLSignatureFactory.getInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String signXML(String xml, PrivateKey signatureKey) throws Exception {
        ByteArrayOutputStream baos = null;
        ByteArrayOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int len;
            this.calcMsgDigest(xml);
            Document doc = this.createSignedDoc(signatureKey);
            NodeList nodeList = doc.getElementsByTagName("DigestValue");
            if (nodeList.getLength() <= 0) {
                throw new Exception("Invalid document structure. Missing <DigestValue> content");
            }
            Node node = nodeList.item(0);
            node = node.getFirstChild();
            node.setNodeValue(this.digestValue);
            this.signatureValue = null;
            nodeList = doc.getElementsByTagName("SignedInfo");
            if (nodeList.getLength() <= 0) {
                throw new Exception("Invalid document structure. Missing <SignedInfo> content");
            }
            node = nodeList.item(0);
            baos = new ByteArrayOutputStream();
            Transformer trans = this.transformerFactory.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(node), new StreamResult(baos));
            baos.close();
            Signature signature = Signature.getInstance(SIGNATUER_ALGO);
            signature.initSign(signatureKey);
            signature.update(this.canonicalizer.canonicalize(baos.toByteArray()));
            byte[] signatureBuf = signature.sign();
            this.signatureValue = Base64.getEncoder().encodeToString(signatureBuf);
            baos = null;
            nodeList = doc.getElementsByTagName("SignatureValue");
            if (nodeList.getLength() <= 0) {
                throw new Exception("Invalid document structure. Missing <SignatureValue> content");
            }
            nodeList.item(0).getFirstChild().setNodeValue(this.signatureValue);
            String textContent = null;
            nodeList = doc.getElementsByTagName("Object");
            if (nodeList.getLength() <= 0) {
                throw new Exception("Invalid document structure. Missing <Object> content");
            }
            node = nodeList.item(0);
            node = node.getFirstChild();
            textContent = node.getTextContent();
            baos = new ByteArrayOutputStream();
            trans = this.transformerFactory.newTransformer();
            trans.transform(new DOMSource(doc), new StreamResult(baos));
            baos.close();
            String tmp = baos.toString("UTF-8");
            baos = null;
            int pos = tmp.indexOf(textContent);
            if (pos == -1) {
                throw new Exception("Invalid document structure or invalid transformation");
            }
            String prefix = tmp.substring(0, pos);
            String suffix = tmp.substring(pos + textContent.length());
            bos = new ByteArrayOutputStream();
            bos.write(prefix.getBytes("UTF-8"));
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            bis = new BufferedInputStream(is);
            boolean flag = true;
            byte[] tmpBuf = new byte[65536];
            while ((len = bis.read(tmpBuf)) != -1) {
                if (flag) {
                    tmp = new String(tmpBuf, 0, len, "UTF-8");
                    flag = false;
                    if (tmp.startsWith("<?xml") && (pos = tmp.indexOf(">")) != -1) {
                        if ((tmp = tmp.substring(pos + 1)).startsWith("\r\n")) {
                            tmp = tmp.substring(2);
                        }
                        if (tmp.startsWith("\n")) {
                            tmp = tmp.substring(1);
                        }
                        if (tmp.startsWith("\r")) {
                            tmp = tmp.substring(1);
                        }
                    }
                    bos.write(tmp.getBytes("UTF-8"));
                    continue;
                }
                bos.write(tmpBuf, 0, len);
            }
            bos.write(suffix.getBytes("UTF-8"));
            String string = bos.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] removeSignature(InputStream is) throws XMLStreamException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLEventReader eventReader = this.xmlInputFactory.createXMLEventReader(is);
        boolean writeEvent = false;
        try (XMLEventWriter writer = this.xmlOutputFactory.createXMLEventWriter(out);){
            block7: while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        if (!"Object".equals(event.asStartElement().getName().getLocalPart())) break;
                        writeEvent = true;
                        if (!eventReader.hasNext()) break;
                        event = eventReader.nextEvent();
                        break;
                    }
                    case 2: {
                        if ("Object".equals(event.asEndElement().getName().getLocalPart())) break block7;
                    }
                }
                if (!writeEvent) continue;
                writer.add(event);
            }
            writer.flush();
            return out.toByteArray();
        }
    }

    private Document createSignedDoc(PrivateKey signatureKey) throws Exception {
        Document doc = null;
        try (BufferedInputStream bis = null;){
            String uri = "";
            doc = this.docBuilder.newDocument();
            Text node = doc.createTextNode("text");
            DOMStructure content = new DOMStructure(node);
            XMLObject xmlobj = this.xmlSigFactory.newXMLObject(Collections.singletonList(content), SIGNATURE_OBJECT_ID, null, null);
            List<XMLObject> xmlObjs = Collections.singletonList(xmlobj);
            if (!"".equals(SIGNATURE_OBJECT_ID)) {
                uri = "#FATCA";
            }
            Reference sigref = this.xmlSigFactory.newReference(uri, this.xmlSigFactory.newDigestMethod(SIGNATURE_DIGEST_METHOD, null), Collections.singletonList(this.xmlSigFactory.newTransform(CANONICALIZATION_METHOD, (TransformParameterSpec)null)), null, null);
            SignedInfo signedInfo = this.xmlSigFactory.newSignedInfo(this.xmlSigFactory.newCanonicalizationMethod(CANONICALIZATION_METHOD, (C14NMethodParameterSpec)null), this.xmlSigFactory.newSignatureMethod(SIGNATURE_METHOD, null), Collections.singletonList(sigref));
            XMLSignature signature = this.xmlSigFactory.newXMLSignature(signedInfo, null, xmlObjs, null, null);
            DOMSignContext dsc = new DOMSignContext(signatureKey, (Node)doc);
            signature.sign(dsc);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcMsgDigest(String xml) throws Exception {
        this.messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGO);
        StringBuilder digestBuf = new StringBuilder();
        digestBuf.append(digprefix);
        try (InputStream is = null;){
            int len;
            is = IOUtils.toInputStream(xml);
            boolean flag = true;
            byte[] tmpBuf = new byte[65536];
            while ((len = is.read(tmpBuf)) != -1) {
                String tmp = new String(tmpBuf, 0, len, "UTF-8");
                tmp = tmp.replace("\r", "");
                if (flag) {
                    int pos;
                    flag = false;
                    if (tmp.startsWith("<?xml") && (pos = tmp.indexOf(">")) != -1 && (tmp = tmp.substring(pos + 1)).startsWith("\n")) {
                        tmp = tmp.substring(1);
                    }
                }
                digestBuf.append(tmp);
            }
        }
        digestBuf.append(digsuffix);
        byte[] data = this.canonicalizer.canonicalize(digestBuf.toString().getBytes());
        this.messageDigest.update(data);
        this.digestValue = Base64.getEncoder().encodeToString(this.messageDigest.digest());
    }
}

