/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.util;

import com.algoritmusistemos.packager.service.util.IOUtils;
import com.algoritmusistemos.packager.service.util.exception.SecurePackagerErrors;
import com.algoritmusistemos.packager.service.util.exception.SecurePackagerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    private static final String AES_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String RSA_TRANSFORMATION = "RSA";
    private static final String SECRET_KEY_ALGO = "AES";
    private static final int SECRET_KEY_SIZE_IN_BITS = 256;
    private static final int SECRET_KEY_SIZE_IN_BYTES = 32;
    private static final int IV_SIZE_IN_BYTES = 16;
    private static final int SECRET_KEY_WITH_IV_SIZE_IN_BYTES = 48;

    private EncryptionUtils() {
    }

    public static Cipher aes(int opmode, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION);
        IvParameterSpec ivp = null;
        if (2 == opmode) {
            byte[] skeyIv = secretKey.getEncoded();
            if (skeyIv.length != 48) {
                throw new SecurePackagerException(SecurePackagerErrors.NKS, skeyIv.length);
            }
            byte[] skey = new byte[32];
            byte[] iv = new byte[16];
            System.arraycopy(skeyIv, 0, skey, 0, skey.length);
            System.arraycopy(skeyIv, skey.length, iv, 0, iv.length);
            secretKey = new SecretKeySpec(skey, SECRET_KEY_ALGO);
            ivp = new IvParameterSpec(iv);
        }
        cipher.init(opmode, (Key)secretKey, ivp);
        return cipher;
    }

    public static InputStream applyCipher(InputStream is, Cipher cipher) {
        return new CipherInputStream(is, cipher);
    }

    public static SecretKey generateAESKey() throws Exception {
        KeyGenerator generator = KeyGenerator.getInstance(SECRET_KEY_ALGO);
        generator.init(256);
        return generator.generateKey();
    }

    public static SecretKey mergeAESKeyWithIV(SecretKey secretKey, byte[] iv) {
        byte[] skey = secretKey.getEncoded();
        byte[] skeyIv = IOUtils.mergeArrays(skey, iv);
        return new SecretKeySpec(skeyIv, SECRET_KEY_ALGO);
    }

    public static InputStream encryptAESKey(SecretKey aesKey, PublicKey receiverPublicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION);
        cipher.init(3, receiverPublicKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(cipher.wrap(aesKey));
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static SecretKey decryptAESKey(byte[] secretKey, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION);
        cipher.init(4, privateKey);
        return (SecretKey)cipher.unwrap(secretKey, SECRET_KEY_ALGO, 3);
    }
}

