/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipInputStream;

public class IOUtils {
    private static final int BUFFER_SIZE = 8096;

    public static InputStream toInputStream(ZipInputStream zis) throws IOException {
        return new ByteArrayInputStream(IOUtils.toByteArray(zis));
    }

    public static InputStream toInputStream(String data) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(data.getBytes("UTF-8"));
    }

    public static String toString(InputStream is) throws IOException {
        return new String(IOUtils.toByteArray(is), "UTF-8");
    }

    public static byte[] toByteArray(String data) throws UnsupportedEncodingException {
        return data.getBytes("UTF-8");
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8096];
        while ((read = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, read);
        }
        return buffer.toByteArray();
    }

    public static byte[] mergeArrays(byte[] arr1, byte[] arr2) {
        byte[] merged = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, merged, 0, arr1.length);
        System.arraycopy(arr2, 0, merged, arr1.length, arr2.length);
        return merged;
    }
}

