/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.util;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class KeyStoreUtils {
    public static String KEYSTORE_TYPE = "JKS";

    public static X509Certificate getCert(String keystorefile, String keystorepwd) throws Exception {
        return KeyStoreUtils.getCert(KEYSTORE_TYPE, keystorefile, keystorepwd, null);
    }

    public static X509Certificate getCert(String keystorefile, String keystorepwd, String alias) throws Exception {
        return KeyStoreUtils.getCert(KEYSTORE_TYPE, keystorefile, keystorepwd, alias);
    }

    public static X509Certificate getCert(String keystoretype, String keystorefile, String keystorepwd, String alias) throws Exception {
        Enumeration<String> e;
        KeyStore keystore = KeyStore.getInstance(keystoretype);
        FileInputStream fis = new FileInputStream(keystorefile);
        keystore.load(fis, keystorepwd.toCharArray());
        fis.close();
        if (alias == null && (e = keystore.aliases()).hasMoreElements()) {
            alias = e.nextElement();
        }
        if (alias != null) {
            X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
            return cert;
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String keystorefile, String keystorepwd, String keypwd, String alias) throws Exception {
        return KeyStoreUtils.getPrivateKey(KEYSTORE_TYPE, keystorefile, keystorepwd, keypwd, alias);
    }

    public static PrivateKey getPrivateKey(String keystorefile, String keystorepwd, String keypwd) throws Exception {
        return KeyStoreUtils.getPrivateKey(KEYSTORE_TYPE, keystorefile, keystorepwd, keypwd, null);
    }

    public static PrivateKey getPrivateKey(String keystoretype, String keystorefile, String keystorepwd, String keypwd, String alias) throws Exception {
        Enumeration<String> e;
        KeyStore keystore = KeyStore.getInstance(keystoretype);
        FileInputStream fis = new FileInputStream(keystorefile);
        keystore.load(fis, keystorepwd.toCharArray());
        fis.close();
        if (alias == null && (e = keystore.aliases()).hasMoreElements()) {
            alias = e.nextElement();
        }
        if (alias != null) {
            PrivateKey privkey = (PrivateKey)keystore.getKey(alias, keypwd.toCharArray());
            if (privkey == null) {
                privkey = (PrivateKey)keystore.getKey(alias.toLowerCase(), keypwd.toCharArray());
            }
            return privkey;
        }
        return null;
    }
}

