/*
 * Decompiled with CFR 0.152.
 */
package com.algoritmusistemos.packager.service.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 8096;

    private ZipUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayInputStream createZipFile(Map<String, InputStream> entries, String zipName) throws IOException {
        ByteArrayOutputStream baos = null;
        try (ZipOutputStream zout = null;){
            baos = new ByteArrayOutputStream();
            zout = new ZipOutputStream(baos);
            byte[] buffer = new byte[8096];
            for (Map.Entry<String, InputStream> entry : entries.entrySet()) {
                InputStream is = entry.getValue();
                zout.putNextEntry(new ZipEntry(entry.getKey()));
                try {
                    int length;
                    while ((length = is.read(buffer)) > 0) {
                        zout.write(buffer, 0, length);
                    }
                }
                finally {
                    is.close();
                    zout.closeEntry();
                }
            }
        }
        return baos != null ? new ByteArrayInputStream(baos.toByteArray()) : null;
    }
}

