#!/bin/bash
# @author Julius Žaldokas (Algoritmų sistemos) (IT:ES:SE:PE))

###########################################################
# 'openssl', 'unzip' and 'xmlsec1' should be in the path. 
# for 'xmlsec1' see https://www.aleksey.com/xmlsec
###########################################################

echo "**********************"
echo "DEFINING VARIABLES"
echo "*********************"

echo TIES_PKG_IN=$TIES_PKG_IN
echo MY_PRIVATE_KEYSTORE_PKCS12_IN=$MY_PRIVATE_KEYSTORE_PKCS12_IN
echo MY_PRIVATE_KEYSTORE_PWD_IN=$MY_PRIVATE_KEYSTORE_PWD_IN
echo SENDER_PUBLIC_CERT_IN=$SENDER_PUBLIC_CERT_IN

echo "*********************"

if [[ -z $TIES_PKG_IN || -z $MY_PRIVATE_KEYSTORE_PKCS12_IN || -z MY_PRIVATE_KEYSTORE_PWD_IN ]]; then
    echo "please see test_unpack.sh....set at least these variables TIES_PKG_IN, MY_PRIVATE_KEYSTORE_PKCS12_IN, MY_PRIVATE_KEYSTORE_PWD_IN)"
    exit 1
fi

####################
# GYPAS_TIES_SA 3.3	DUOMENŲ PAKETO IŠPAKAVIMO ŽINGSNIAI
# 	1.1 - IŠARCHYVUOTI GAUTĄ FAILĄ
#
# unzip TIES_PKG_IN
####################

if [[ ! -f $TIES_PKG_IN || ! -f $MY_PRIVATE_KEYSTORE_PKCS12_IN ]]; then
    echo "ERROR: either $TIES_PKG_IN or $MY_PRIVATE_KEYSTORE_PKCS12_IN does not exit"
    exit 1
fi

echo "unzipping '$TIES_PKG_IN'...."

declare -a arr=(`unzip -Z2 ${TIES_PKG_IN}`)

i=0
while true; do
	tmp=${arr[$i]#*_}
	tmp="${tmp//$'\r'/}"
	# Equality Comparison
    if [[ ${tmp} = Payload ]]; then
        payload_file=${arr[$i]}
		payload_file="${payload_file//$'\r'/}"
    elif [[ ${tmp} = Key ]]; then
        key_file=${arr[$i]}
		key_file="${key_file//$'\r'/}"
    fi
    i=$[$i+1]
    if [[ $i -eq ${#arr[@]} ]]; then
        break;
    fi
done

if [[ -z $payload_file || -z $key_file ]]; then
    echo "invalid $TIES_PKG_IN - one or more file missing"
    exit 1
fi

CMD="unzip -oq $TIES_PKG_IN"

echo;echo $CMD;$CMD

if [[ "$?" -ne 0 ]]; then
    echo "!!!! please fix the error !!!!";echo $CMD;echo
    rm -f $key_file $payload_file
    exit 1
fi

echo;echo "unzipping '$TIES_PKG_IN'....done"
echo;echo "extracting private key from keystore '$MY_PRIVATE_KEYSTORE_PKCS12_IN'...."

####################
# GYPAS_TIES_SA 3.3	DUOMENŲ PAKETO IŠPAKAVIMO ŽINGSNIAI
# 	2.1 - IŠŠIFRUOTI AES RAKTĄ NAUDOJANT PRIVATŲ RAKTĄ
#
# Decrypt encrypted AESKEY+IV using receiver's RSA PKI private key
####################

private_key_pem_file=`echo ${key_file}.pem`

CMD="openssl pkcs12 -in $MY_PRIVATE_KEYSTORE_PKCS12_IN -nocerts -passin pass:$MY_PRIVATE_KEYSTORE_PWD_IN -nodes" > $private_key_pem_file

echo;echo "$CMD > $private_key_pem_file";$CMD > $private_key_pem_file

if [[ "$?" -ne 0 ]]; then
    echo "!!!! please fix the error !!!!";
    echo;echo "$CMD > $private_key_pem_file";$CMD > $private_key_pem_file
    rm -f $key_file $payload_file $private_key_pem_file
    exit 1
fi

echo;echo "extracting private key from keystore '$MY_PRIVATE_KEYSTORE_PKCS12_IN'....done"
echo;echo "decrypting '$key_file' using private key from '$private_key_pem_file'...."

CMD="TMP=\`openssl rsautl -decrypt -in $key_file -inkey $private_key_pem_file | perl -pe '\$_=unpack("H*",\$_)'\`"

echo;echo $CMD;

TMP=`openssl rsautl -decrypt -in $key_file -inkey $private_key_pem_file|perl -pe '$_=unpack("H*", $_)'`

if [[ "$?" -ne 0 ]]; then
    echo "!!!! please fix the error !!!!";echo $CMD;echo
    rm -f $key_file $payload_file $private_key_pem_file
    exit 1
fi

# Extract 32 bytes AESKEY and 16 bytes IV
AESKEY2DECRYPT=`echo ${TMP:0:64}`
IV2DECRYPT=`echo ${TMP:64:96}`

####################
# GYPAS_TIES_SA 3.3	DUOMENŲ PAKETO IŠPAKAVIMO ŽINGSNIAI
# 	3.1 - IŠŠIFRUOTI ARCHYVUOTĄ XML FAILĄ SU ANKSTESNIAME ŽINGSNYJE IŠŠIFRUOTU AES-256 RAKTU
#
# Decrypt payload using D_AESKEY and D_IV
####################

payload_zip_file=`echo ${payload_file}.zip`
CMD="openssl enc -d -aes-256-cbc -in $payload_file -out $payload_zip_file -K $AESKEY2DECRYPT -iv $IV2DECRYPT"

echo;echo $CMD;$CMD

if [[ "$?" -ne 0 ]]; then
    echo "!!!! please fix the error !!!!";echo $CMD;echo
    #rm -f $key_file $payload_file $private_key_pem_file
    exit 1
fi

# Check if payload_zip_file are created
if [[ ! -f $payload_zip_file ]]; then
    echo "!!!! please fix the error !!!!";echo $CMD;echo
    rm -f $key_file $payload_file $private_key_pem_file
    exit 1
fi

echo;echo "decrypting '$key_file' using private key from '$private_key_pem_file'....done"

####################
# GYPAS_TIES_SA 3.3	DUOMENŲ PAKETO IŠPAKAVIMO ŽINGSNIAI
# 	4.1 - IŠARCHYVUOTI IŠŠIFRUOTĄ FAILĄ 00000000000_PAYLOAD.ZIP
#
####################

echo;echo "unzipping '$payload_zip_file'...."

CMD="unzip -oq $payload_zip_file"

echo;echo $CMD;$CMD

payload_xml_file=${payload_file}.xml

# Check if $payload_xml_file is created
if [[ "$?" -ne 0 || ! -f $payload_xml_file ]]; then
    echo "!!!! please fix the error !!!!";echo $CMD;echo
    rm -f $key_file $payload_file $private_key_pem_file
    exit 1
fi

echo;echo "unzipping '$payload_zip_file'....done"

####################
# GYPAS_TIES_SA 3.3	DUOMENŲ PAKETO IŠPAKAVIMO ŽINGSNIAI
# 	5.1 - Naudojant teikėjo (VMI) viešąjį raktą patikrinti parašą įsitikinant siuntėjo ir duomenų paketo autentiškumu.
#
####################

error_flag=0

if [[ ! -z $SENDER_PUBLIC_CERT_IN && -f $SENDER_PUBLIC_CERT_IN ]]; then
    echo;echo "verifying signature of '$payload_xml_file'...."

    CMD="xmlsec1 --verify --pubkey-cert-der $SENDER_PUBLIC_CERT_IN $payload_xml_file" 

    echo;echo $CMD;$CMD 2>&1

    if [[ "$?" -eq 0 ]]; then
        echo;echo "'$payload_xml_file' signature verification succeed"
    else
        echo;echo "ERROR: '$payload_xml_file' signature verification failed"
        error_flag=1
    fi

    echo;echo "verifying signature of '$payload_xml_file'....done"
fi

if [[ error_flag -eq 0 ]]; then
    echo;echo "success!!!! unpacked $payload_xml_file"
fi

rm -f $key_file $payload_file $private_key_pem_file $payload_zip_file